/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: InformationDialog.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 21.03.07 17:50 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Basic Information Dialog for displaying Driver/Channel Information
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        30.06.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file InformationDialog.h
///   Basic Information Dialog for displaying Driver/Channel Information
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "CifXDeviceBase.h"
#include "afxcmn.h"

extern const __declspec(selectany) struct SYSCHANNEL_INFOStag
{
  LPCTSTR szInfo;
  ULONG   ulInfo;

} SYSCHANNEL_INFOS[] =
{
  {_T("Generic Information"), CIFX_INFO_CMD_SYSTEM_INFORMATION},
  {_T("Info Block"),          CIFX_INFO_CMD_SYSTEM_INFO_BLOCK},
  {_T("Channel Block"),       CIFX_INFO_CMD_SYSTEM_CHANNEL_BLOCK},
  {_T("Control Block"),       CIFX_INFO_CMD_SYSTEM_CONTROL_BLOCK},
  {_T("Status Block"),        CIFX_INFO_CMD_SYSTEM_STATUS_BLOCK},
};

extern const __declspec(selectany) struct CHANNEL_INFOStag
{
  LPCTSTR szInfo;
  ULONG   ulInfo;

} CHANNEL_INFOS[] =
{
  {_T("Generic Information"), CIFX_INFO_CHANNEL},
  {_T("I/O Information"),     CIFX_INFO_CHANNELIO},
};

///////////////////////////////////////////////////////////////////////////////////////////
///  Basic Information Dialog for displaying Driver/Channel Information
///////////////////////////////////////////////////////////////////////////////////////////
class CInformationDialog : public CBaseDialog
{
	DECLARE_DYNAMIC(CInformationDialog)

public:
  CInformationDialog(CWnd* pParent = NULL);   // standard constructor
	virtual ~CInformationDialog();

// Dialog Data
	enum { IDD = IDD_INFO_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnUpdate();

  /////////////////////////////////////////////////////
  /// Type of properties to display (identifies the fetching routines)
  /////////////////////////////////////////////////////
  typedef enum
  { 
    eDRIVERINFO,    //!< use driver infos (call static member of CCifXDeviceBase)
    eCHANNELINFO,   //!< use channel infos (calls currently opened device)

  } PROPERTY_TYPE;

  void SetType(PROPERTY_TYPE eType);
  void SetCaption(LPCTSTR szCaption)                 { m_csCaption = szCaption; }

  void ThreadFunction()                              { }
  void OnUpdateDevice(CCifXDeviceBase* pcDevice) 
  { 
    if(NULL != pcDevice)
    {
      SetCaption(pcDevice->GetChannelInfoName());
      SetType(m_eType);
    }
  }

protected:
  CListCtrl                           m_cPropertyListCtrl;    //!< List control containing the properties
  CComboBox                           m_cAdditionalSelection; //!< Additional Combobox for channelinfo suboptions
  CString                             m_csCaption;            //!< Caption to set on update

  PROPERTY_TYPE                       m_eType;                //!< Currently selected type

public:
  virtual BOOL OnInitDialog();
  void    UpdateValues(void);
  afx_msg void OnCbnSelchangeCbSelection();
};
